using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class REGISTRY_CORE_DATADB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public REGISTRY_CORE_DATADB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public REGISTRY_CORE_DATA GetItemByRegistryCore(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CORE_TYPE_ID)
        {
            REGISTRY_CORE_DATA objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_CORE_DATA_getitemByRegistryCore(CURRENT_USER, CURRENT_REGISTRY_ID, CORE_TYPE_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REGISTRY_CORE_DATA> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REGISTRY_CORE_DATA> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_REGISTRY_CORE_DATA_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = dbContext.usp_REGISTRY_CORE_DATA_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = objReturn.Where(r => r.STD_REGISTRY_ID == CURRENT_REGISTRY_ID).ToList();
                    if (objReturn != null)
                    {
                        foreach (REGISTRY_CORE_DATA d in objReturn)
                        {
                            if (d.CORE_TYPE_ID > 0)
                                d.STD_REGISTRY_CORE_TYPES = dbContext.usp_STD_REGISTRY_CORE_TYPES_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, d.CORE_TYPE_ID).FirstOrDefault();
                        }
                    }

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean SaveList(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, List<REGISTRY_CORE_DATA> cohorts)
        {
            Boolean objReturn = false;
            Int32? objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    foreach (REGISTRY_CORE_DATA objSave in cohorts)
                    {
                        objTemp = objSave.CORE_DATA_ID;
                        LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                        dbContext.usp_REGISTRY_CORE_DATA_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENT, ref objTemp, objSave.CORE_TYPE_ID, DateTime.Now, objSave.CREATEDBY, objSave.SELECTED_FLAG, objSave.STD_REGISTRY_ID, DateTime.Now, objSave.UPDATEDBY, objSave.VALUE);
                        LogManager.LogTiming(logDetails);
                    }

                    objReturn = true;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }
      
        #endregion
	}
}
